#define GmnModelBufferClear
// GMNewton 1.00
//
//Function:  Clears the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//call GmnModelBufferClear();
//return: 
return external_call(global.__GmnModelBufferClear__);

#define GmnModelBufferAdd
// GMNewton 1.00
//
//Function:  Adds a point to the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//   Argument0 - x
//   Argument1 - y
//   Argument2 - z
//call GmnModelBufferAdd(x,y,z);
//return: 
return external_call(global.__GmnModelBufferAdd__,argument0,argument1,argument2);

#define GmnModelBufferAddFromList
// GMNewton 1.00
//
//Function:
//Notes:
//
//Arguments:
//   Argument0 - list
//call GmnModelBufferAddFromList(list);
//return: number of points added
var pointcount;
pointcount=floor(ds_list_size(argument0)/3);
for(i=0;i<pointcount;i+=1){
   v_x=ds_list_find_value(argument0,i*3);
   v_y=ds_list_find_value(argument0,i*3+1);
   v_z=ds_list_find_value(argument0,i*3+2);
   //show_message(string(pointcount)+"##"+string(v_x)+"#"+string(v_y)+"#"+string(v_z));
   external_call(global.__GmnModelBufferAdd__,v_x,v_y,v_z);
}

return(pointcount); 

#define GmnModelBufferLoadMod
//Argument0 - path to model.
//Argument1 - scale.  Defaults to 1.
//
//returns model id
//Loades a model to dll from mod file.

var filetext,data,file,modelid,start,count,lines,i,point_count;

if(argument1=0){
   argument1=1;
}
point_count=0;

data=ds_list_create();


if(!file_exists(argument0)) return(-1);//return -1 if file not found

file=file_text_open_read(argument0);
GmnModelBufferClear()//Clear the model buffer
show_debug_message("start load model:"+argument0)
file_text_readln(file);
lines=file_text_read_real(file);
file_text_readln(file);
file_text_readln(file);//navigate to start of model data

for(i=0;i<lines-2;i+=1){
   filetext=file_text_read_string(file);
   if(string_count(" ",filetext)>=3){
      start=string_pos_ext(" " , filetext , 1)+1;
      count=string_pos_ext(" " , filetext , 4)-start
      filetext=string_copy(filetext,start,count);
      ds_list_clear(data);
      string_to_list_ext(filetext," ",data);
      scale_list(data,argument1);
      point_count+=1;
      GmnModelBufferAddFromList(data);
      ds_list_clear(data)
   }else{
      show_debug_message("not enough data in line : "+filetext);
   }
   if(i<lines-3){
      file_text_readln(file);
   }
}
ds_list_destroy(data);
file_text_close(file);
return(1);


#define GmnModelBufferCount
// GMNewton 1.00
//
//Function:  Returns the number of points in the model buffer
//Notes:  GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//call GmnModelBufferCount();
//return: 
return external_call(global.__GmnModelBufferCount__);

#define GmnCreateConvexHull
// GMNewton 1.00
//
//Function:  Creates a convex hull collision shape from the points in the model buffer
//Notes:  Offets define position relative to origin
//        tolerance is a value between 0 and 1 telling Newton how much leeway it has in optimizing the hull.
//          0 yields the best representation, while 1 yields the fastest but least acurate representation
//        GMNewton has a model buffer that is used to transfer models to it point by point or convex hull generation
//
//Arguments:
//   Argument0 - dWorld
//   Argument1 - offset_x
//   Argument2 - offset_y
//   Argument3 - offset_z
//   Argument4 - tolerance
//call GmnCreateConvexHull(dWorld,offset_x,offset_y,offset_z,tolerance);
//return: 
return external_call(global.__GmnCreateConvexHull__,argument0,argument1,argument2,argument3,argument4);

